<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
    <xsl:param name="xslResourceDirectory" select="cif:xslResourceDirectory"/>
    <!-- CDOT Monumentation List Coordinates Report -->
    <xsl:template match="/">
    	  <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))" />
        <html>
            <head>
                <link rel="stylesheet" type="text/css" href="{$xslResourceDirectory}/engtheme.css"/>
                <!-- Title displayed in browser Title Bar -->
                <title lang="en">Monumentation List Coordinates Report</title>
            </head>
            <body>
                <xsl:for-each select="InRoads">
                    <center>
                        <!-- Report Title -->
			            <h1>&#xa0;</h1>                        
                        <h2 lang="en">CDOT Monumentation List Coordinates Report</h2>
                        <p lang="en">
                            Report Created:&#xa0; <xsl:value-of select="cif:date()"/><br/>
                            Time:&#xa0; <xsl:value-of select="cif:time()"/>
                        </p>
                    </center>
                    <!-- Project Data -->
                    <xsl:for-each select="GeometryProject">
                        <table class="margin" cellpadding="2" width="90%">
                            <tbody>
                                <tr>
                                    <th align="right" lang="en">Project:&#xa0; </th>
                                    <td align="left" colspan="2"><xsl:value-of select="@name"/></td>
                                </tr>
                                <tr>
                                    <th align="right" lang="en">Description:&#xa0; </th>
                                    <td align="left" colspan="2"><xsl:value-of select="@description"/></td>
                                </tr>
                                <tr>
                                    <th align="right" lang="en">File Name:&#xa0; </th>
                                    <td align="left" colspan="2"><xsl:value-of select="@file"/></td>
                                </tr>
                                <tr>
                                    <th align="right" lang="en">Last Revised:&#xa0; </th>
                                    <td align="left" colspan="2"><xsl:value-of select="concat(@lastRevisedBy, '  ', @lastRevisedDate)"/></td>
                                </tr>
                               <!-- <tr>
                                    <th align="right" lang="en" style="font-size: 80%">Input Grid Factor:&#xa0; </th>
                                    <td align="left" style="font-size: 80%"><xsl:value-of select="../@inputGridScaleFactor" /></td>
                                    <td align="right" lang="en" style="font-size: 80%">
                                        <strong>Note:&#xa0; </strong>All units in this report are in
                                        <xsl:if test="//@linearUnits = 'Imperial'">feet</xsl:if>
                                        <xsl:if test="//@linearUnits = 'Metric'">meters</xsl:if>
                                        unless specified otherwise.
                                    </td>
                                </tr> -->
                            </tbody>
                        </table>
                        <hr />
                        <!-- Horizontal Alignment Data -->
                        <xsl:for-each select="HorizontalAlignment">
                            <table cellpadding="4">
                                <tbody>
                                    <tr>
                                        <th align="right" lang="en">Alignment Name:</th>
                                        <td align="left">
                                            <xsl:value-of select="@name"/>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                            <table class="margin" cellpadding="2" cellspacing="5" width="90%">
                                <thead>
                                    <tr>
                                        <th class="underline" lang="en">Point<br />Number</th>
                                        <th class="underline" lang="en">Northing</th>
                                        <th class="underline" lang="en">Easting</th>
                                        <th class="underline" lang="en">Elevation</th>
										 <th class="underline" lang="en">Description</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <xsl:for-each select="HorizontalElements">
                                        <xsl:apply-templates/>
                                    </xsl:for-each>
                                </tbody>
                            </table>
                        </xsl:for-each>
                        <!-- Cogo Point Data -->
                        <xsl:for-each select="CogoPoints">
                            <table cellpadding="4">
                                <tbody>
                                    <tr>
                                        <th align="left" lang="en">Cogo Points</th>
                                    </tr>
                                </tbody>
                            </table>
                            <table class="margin" cellpadding="2" cellspacing="5" width="90%"> 
                                <thead>
                                    <tr>
                                        <th class="underline" lang="en">Point<br />Number</th>
                                        <th class="underline" lang="en">Northing</th>
                                        <th class="underline" lang="en">Easting</th>
                                        <th class="underline" lang="en">Elevation</th>
										<th>&#xa0;</th>
                                        <th class="underline" lang="en">Description</th>
                                        <!-- <th><i>style</i></th> -->
                                    </tr>
                                </thead>
                                <tbody>
                                    <xsl:for-each select="GeometryPoint">
									<xsl:sort select="@style"/>
									<xsl:sort select="@name"/>                                                            
                                        <tr>
                                            <td align="center"><xsl:value-of select="@name"/></td>
                                            <td align="right"><xsl:value-of select="cif:ordinateFormat(number(@northing))"/></td>
                                            <td align="right"><xsl:value-of select="cif:ordinateFormat(number(@easting))"/></td>
                                            <td align="right"><xsl:value-of select="cif:distanceFormat(number(@elevation))"/></td>
											<td>&#xa0;</td>
										    <td align="left"><xsl:value-of select="@description"/></td>
										    <!-- <td><i><xsl:value-of select="@style"/></i></td> -->
                                        </tr>
                                    </xsl:for-each>
                                </tbody>
                            </table>
                        </xsl:for-each>
                    </xsl:for-each>
                </xsl:for-each>
            </body>
        </html>
    </xsl:template>
    <!-- Element Point Data -->
    <xsl:template match="Start | PI | Center | End[@type='POE']">
        <tr>
            <td align="center"><xsl:value-of select="@name"/></td>
            <td align="right"><xsl:value-of select="cif:ordinateFormat(number(@northing))"/></td>
            <td align="right"><xsl:value-of select="cif:ordinateFormat(number(@easting))"/></td>
            <td align="right"><xsl:value-of select="cif:distanceFormat(number(@elevation))"/></td>
 		    <td align="left"><xsl:value-of select="@description"/></td>            
        </tr>
    </xsl:template>
</xsl:stylesheet>
